import request from "@/utils/request";

export function getList(queryParams, examId) {
  return request({
    url: `/epidemicDetail/list/${examId}`,
    // url:`/epidemicDetail/list`,
    method: 'get',
    params: queryParams
  })
}

export function addToList(reqFormData, examId) {
  return request({
    url: `/epidemicDetail/add/${examId}`,
    method: 'post',
    data: reqFormData
  })
}

export function editOnList(reqFormData, examId) {
  return request({
    url: `/epidemicDetail/edit/${examId}`,
    method: 'put',
    data: reqFormData
  })
}

export function deleteData(ids) {
  return request({
    url: `/epidemicDetail/delete/${ids}`,
    method: 'delete',
  })
}

// 导入
export function handleImport(file, examId) {
  return request({
    url: `/epidemicDetail/importData/${examId}`,
    method: 'post',
    data: file
  })
}

export class BackToFrontTransfer {
  constructor(data) {
    this.examId = data.examId
    this.id = data.id
    this.sort = data.sort
    this.subjectType = data.subjectType
    this.quizTitle = data.subjectTitle
    this.optionA = data.optionA
    this.optionB = data.optionB
    this.optionC = data.optionC
    this.optionD = data.optionD
    this.optionE = data.optionE
    this.optionF = data.optionF
    this.optionG = data.optionG
    this.optionH = data.optionH
    this.answer = data.answer
    this.score = data.score
    this.pointsA = data.scoreA
    this.pointsB = data.scoreB
    this.pointsC = data.scoreC
    this.pointsD = data.scoreD
    this.pointsE = data.scoreE
    this.pointsF = data.scoreF
    this.pointsG = data.scoreG
    this.pointsH = data.scoreH
  }
}

export class FrontToBackTransfer {
  constructor(data) {
    this.examId = data.examId
    this.id = data.id
    this.sort = data.sort
    this.subjectType = data.subjectType
    this.subjectTitle = data.quizTitle
    this.optionA = data.optionA
    this.optionB = data.optionB
    this.optionC = data.optionC
    this.optionD = data.optionD
    this.optionE = data.optionE
    this.optionF = data.optionF
    this.optionG = data.optionG
    this.optionH = data.optionH
    this.answer = data.answer
    this.score = data.score
    this.scoreA = data.pointsA
    this.scoreB = data.pointsB
    this.scoreC = data.pointsC
    this.scoreD = data.pointsD
    this.scoreE = data.pointsE
    this.scoreF = data.pointsF
    this.scoreG = data.pointsG
    this.scoreH = data.pointsH
  }
}
