import request from "@/utils/request";

// 查询工作量信息列表
export function listAworkload(query) {
  return request({
    url: "/aworkload/list",
    method: "get",
    params: query,
  });
}

// 查询工作量信息详细
export function getAworkload(id) {
  return request({
    url: "/aworkload/" + id,
    method: "get",
  });
}

// 新增工作量信息
export function addAworkload(data) {
  return request({
    url: "/aworkload",
    method: "post",
    data: data,
  });
}

// 修改工作量信息
export function updateAworkload(data) {
  return request({
    url: "/aworkload",
    method: "put",
    data: data,
  });
}

// 删除工作量信息
export function delAworkload(id) {
  return request({
    url: "/aworkload/" + id,
    method: "delete",
  });
}
