import request from "@/utils/request";

// 查询团队获奖列表
export function listAward(query) {
  return request({
    url: "/school/award/list",
    method: "get",
    params: query,
  });
}

//查询个人获奖列表
export function listAwardgr(query) {
  return request({
    url: "/school/award/personlist",
    method: "get",
    params: query,
  });
}

// 查询团队获奖详细
export function getAward(id) {
  return request({
    url: "/school/award/" + id,
    method: "get",
  });
}

// 新增团队获奖
export function addAward(data) {
  return request({
    url: "/school/award",
    method: "post",
    data: data,
  });
}

// 修改团队获奖
export function updateAward(data) {
  return request({
    url: "/school/award",
    method: "put",
    data: data,
  });
}
// 审核
export function audit(data) {
  return request({
    url: "/school/award",
    method: "put",
    data: data,
  });
}
// 删除团队获奖
export function delAward(id) {
  return request({
    url: "/school/award/" + id,
    method: "delete",
  });
}
