import request from "@/utils/request";

// 查询班主任考核列表
export function listAssessment(query) {
  return request({
    url: "/assessment/list",
    method: "get",
    params: query,
  });
}
export function listAssessmentall(query) {
  return request({
    url: "/assessment/listAll",
    method: "get",
    params: query,
  });
}
// 查询班主任考核详细
export function getAssessment(id) {
  return request({
    url: "/assessment/" + id,
    method: "get",
  });
}

// 新增班主任考核
export function addAssessment(data) {
  return request({
    url: "/assessment",
    method: "post",
    data: data,
  });
}

// 修改班主任考核
export function updateAssessment(data) {
  return request({
    url: "/assessment",
    method: "put",
    data: data,
  });
}

// 删除班主任考核
export function delAssessment(id) {
  return request({
    url: "/assessment/" + id,
    method: "delete",
  });
}
