import request from "@/utils/request";

// 查询辅导教师获奖列表
export function listAward(query) {
  return request({
    url: "/school/fudaot/teacher",
    method: "get",
    params: query,
  });
}
//查看辅导教师列表（个人）
export function listAwardgr(query) {
  return request({
    url: "/school/fudaot/teacherGr",
    method: "get",
    params: query,
  });
}
// 查询辅导教师获奖详细
export function getAward(id) {
  return request({
    url: "/school/fudaot/" + id,
    method: "get",
  });
}

// 新增辅导教师获奖
export function addAward(data) {
  return request({
    url: "/school/fudaot/addgl",
    method: "post",
    data: data,
  });
}
// 新增辅导教师获奖（个人）
export function addAwardgr(data) {
  return request({
    url: "/school/fudaot/add",
    method: "post",
    data: data,
  });
}

// 修改辅导教师获奖
export function updateAward(data) {
  return request({
    url: "/school/fudaot/edit",
    method: "put",
    data: data,
  });
}

// 删除辅导教师获奖
export function delAward(id) {
  return request({
    url: "/school/fudaot/delete/" + id,
    method: "delete",
  });
}
//审核
export function audit(data) {
  return request({
    url: "/school/fudaot/submit",
    method: "put",
    data: data,
  });
}
