import request from "@/utils/request";

// 查询教学成绩列表
export function listAchievements(query) {
  return request({
    url: "/system/achievements/list",
    method: "get",
    params: query,
  });
}

// 查询教学成绩详细
export function getAchievements(id) {
  return request({
    url: "/system/achievements/" + id,
    method: "get",
  });
}

// 新增教学成绩
export function addAchievements(data) {
  return request({
    url: "/system/achievements",
    method: "post",
    data: data,
  });
}

// 修改教学成绩
export function updateAchievements(data) {
  return request({
    url: "/system/achievements",
    method: "put",
    data: data,
  });
}

// 删除教学成绩
export function delAchievements(id) {
  return request({
    url: "/system/achievements/" + id,
    method: "delete",
  });
}
