import request from "@/utils/request";

// 查询教师获奖列表
export function listAwards(query) {
  return request({
    url: "/school/teacherAwards/list",
    method: "get",
    params: query,
  });
}
// 查询教师获奖列表个人
export function listAwardsgr(query) {
  return request({
    url: "/school/teacherAwards/listGr",
    method: "get",
    params: query,
  });
}
// 查询教师获奖详细
export function getAwards(id) {
  return request({
    url: "/school/teacherAwards/" + id,
    method: "get",
  });
}

// 新增教师获奖
export function addAwards(data) {
  return request({
    url: "/school/teacherAwards",
    method: "post",
    data: data,
  });
}

// 修改教师获奖
export function updateAwards(data) {
  return request({
    url: "/school/teacherAwards",
    method: "put",
    data: data,
  });
}

// 删除教师获奖
export function delAwards(id) {
  return request({
    url: "/school/teacherAwards/" + id,
    method: "delete",
  });
}
//审核
export function audit(data) {
  return request({
    url: "/school/teacherAwards/audit",
    method: "post",
    data: data,
  });
}
