import request from "@/utils/request";

// 查询课题研究列表
export function listResearch(query) {
  return request({
    url: "/system/research/list",
    method: "get",
    params: query,
  });
}
// 查询课题研究列表个人
export function listResearchgr(query) {
  return request({
    url: "/system/research/listGr",
    method: "get",
    params: query,
  });
}
// 查询课题研究详细
export function getResearch(id) {
  return request({
    url: "/system/research/" + id,
    method: "get",
  });
}

// 新增课题研究
export function addResearch(data) {
  return request({
    url: "/system/research",
    method: "post",
    data: data,
  });
}

// 修改课题研究
export function updateResearch(data) {
  return request({
    url: "/system/research",
    method: "put",
    data: data,
  });
}

// 删除课题研究
export function delResearch(id) {
  return request({
    url: "/system/research/" + id,
    method: "delete",
  });
}
//审核
export function audit(data) {
  return request({
    url: "/system/research/audit",
    method: "post",
    data: data,
  });
}
