import request from "@/utils/request";

// 查询讲课获奖列表
export function listAwards(query) {
  return request({
    url: "/system/awards/list",
    method: "get",
    params: query,
  });
}

// 查询讲课获奖列表
export function listAwardsgr(query) {
  return request({
    url: "/system/awards/listGr",
    method: "get",
    params: query,
  });
}
// 查询讲课获奖详细
export function getAwards(id) {
  return request({
    url: "/system/awards/" + id,
    method: "get",
  });
}

// 新增讲课获奖
export function addAwards(data) {
  return request({
    url: "/system/awards",
    method: "post",
    data: data,
  });
}

// 修改讲课获奖
export function updateAwards(data) {
  return request({
    url: "/system/awards",
    method: "put",
    data: data,
  });
}

// 删除讲课获奖
export function delAwards(id) {
  return request({
    url: "/system/awards/" + id,
    method: "delete",
  });
}
//审核
export function audit(data) {
  return request({
    url: "/system/awards/audit",
    method: "post",
    data: data,
  });
}
