import request from "@/utils/request";

// 查询论文著作列表
export function listWorks(query) {
  return request({
    url: "/system/works/list",
    method: "get",
    params: query,
  });
}
// 查询论文著作列表个人
export function listWorksgr(query) {
  return request({
    url: "/system/works/listGr",
    method: "get",
    params: query,
  });
}

// 查询论文著作详细
export function getWorks(id) {
  return request({
    url: "/system/works/" + id,
    method: "get",
  });
}

// 新增论文著作
export function addWorks(data) {
  return request({
    url: "/system/works",
    method: "post",
    data: data,
  });
}

// 修改论文著作
export function updateWorks(data) {
  return request({
    url: "/system/works",
    method: "put",
    data: data,
  });
}

// 删除论文著作
export function delWorks(id) {
  return request({
    url: "/system/works/" + id,
    method: "delete",
  });
}
//审核
export function audit(data) {
  return request({
    url: "/system/works/audit",
    method: "post",
    data: data,
  });
}
