import request from "@/utils/request";

// 查询综合荣誉列表
export function listHonors(query) {
  return request({
    url: "/system/honors/list",
    method: "get",
    params: query,
  });
}
//查看综合荣誉列表（个人）
export function listHonorsgr(query) {
  return request({
    url: "/system/honors/listGr",
    method: "get",
    params: query,
  });
}

// 查询综合荣誉详细
export function getHonors(id) {
  return request({
    url: "/system/honors/" + id,
    method: "get",
  });
}

// 新增综合荣誉
export function addHonors(data) {
  return request({
    url: "/system/honors",
    method: "post",
    data: data,
  });
}

// 修改综合荣誉
export function updateHonors(data) {
  return request({
    url: "/system/honors",
    method: "put",
    data: data,
  });
}

// 删除综合荣誉
export function delHonors(id) {
  return request({
    url: "/system/honors/" + id,
    method: "delete",
  });
}

//获取用户
export function getUserList(data) {
  return request({
    url: "/system/achievements/getUserList",
    method: "get",
    params: data,
  });
}
//审核
export function audit(data) {
  return request({
    url: "/system/honors/audit",
    method: "post",
    data: data,
  });
}
