import request from "@/utils/request";

// 查看辅导学生获奖列表
export function listAward(query) {
  return request({
    url: "/school/fudaos/studentlist",
    method: "get",
    params: query,
  });
}
//查看辅导教师列表（个人）
export function listAwardgr(query) {
  return request({
    url: "/school/fudaos/studentlistGr",
    method: "get",
    params: query,
  });
}
// 查询辅导教师获奖详细
export function getAward(id) {
  return request({
    url: "/school/fudaos/" + id,
    method: "get",
  });
}

// 新增辅导教师获奖
export function addAward(data) {
  return request({
    url: "/school/fudaos/addgl",
    method: "post",
    data: data,
  });
}
// 新增辅导教师获奖（个人）
export function addAwardgr(data) {
  return request({
    url: "/school/fudaos/add",
    method: "post",
    data: data,
  });
}

// 修改辅导教师获奖
export function updateAward(data) {
  return request({
    url: "/school/fudaos/edit",
    method: "put",
    data: data,
  });
}

// 删除辅导教师获奖
export function delAward(id) {
  return request({
    url: "/school/fudaos/delete/" + id,
    method: "delete",
  });
}
//审核
export function audit(data) {
  return request({
    url: "/school/fudaos/submit",
    method: "put",
    data: data,
  });
}
