import request from "@/utils/request";

// 查询年度考核列表
export function listAssessment(query) {
  return request({
    url: "/school/annualAssessment/list",
    method: "get",
    params: query,
  });
}

// 查询年度考核详细
export function getAssessment(id) {
  return request({
    url: "/school/annualAssessment/" + id,
    method: "get",
  });
}

// 新增年度考核
export function addAssessment(data) {
  return request({
    url: "/school/annualAssessment",
    method: "post",
    data: data,
  });
}

// 修改年度考核
export function updateAssessment(data) {
  return request({
    url: "/school/annualAssessment",
    method: "put",
    data: data,
  });
}

// 删除年度考核
export function delAssessment(id) {
  return request({
    url: "/school/annualAssessment/" + id,
    method: "delete",
  });
}

// 导出接口
export function exportAssessment(data) {
  return request({
    url: "/school/annualAssessment/export",
    method: "post",
    data: data,
  });
}
