import request from "@/utils/request";

// 查询高考成绩列表
export function listAchievement(query) {
  return request({
    url: "/achievement/list",
    method: "get",
    params: query,
  });
}
// 查询高考成绩列表（个人）
export function listAchievementgr(query) {
  return request({
    url: "/achievement/teacher/list",
    method: "get",
    params: query,
  });
}

//审核
export function audit(data) {
  return request({
    url: "/achievement",
    method: "put",
    data: data,
  });
}
// 查询高考成绩详细
export function getAchievement(id) {
  return request({
    url: "/achievement/" + id,
    method: "get",
  });
}

// 新增高考成绩
export function addAchievement(data) {
  return request({
    url: "/achievement",
    method: "post",
    data: data,
  });
}

// 修改高考成绩
export function updateAchievement(data) {
  return request({
    url: "/achievement",
    method: "put",
    data: data,
  });
}

// 删除高考成绩
export function delAchievement(id) {
  return request({
    url: "/achievement/" + id,
    method: "delete",
  });
}
