import request from "@/utils/request";

// 查询青年教师成长档案列表
export function listYouthTeacher(query) {
  return request({
    url: "/school/youthTeacher/list",
    method: "get",
    params: query,
  });
}

// 查询青年教师成长档案详细
export function getYouthTeacher(id) {
  return request({
    url: "/school/youthTeacher/" + id,
    method: "get",
  });
}

// 新增青年教师成长档案
export function addYouthTeacher(data) {
  return request({
    url: "/school/youthTeacher",
    method: "post",
    data: data,
  });
}

// 修改青年教师成长档案
export function updateYouthTeacher(data) {
  return request({
    url: "/school/youthTeacher",
    method: "put",
    data: data,
  });
}

// 删除青年教师成长档案
export function delYouthTeacher(id) {
  return request({
    url: "/school/youthTeacher/" + id,
    method: "delete",
  });
}
