import request from "@/utils/request";

// 查询教师基础信息列表
export function listInformation(query) {
  return request({
    url: "/teacher/basiclnformation/list",
    method: "get",
    params: query,
  });
}

// 查询教师基础信息详细
export function getInformation(id) {
  return request({
    url: "/teacher/basiclnformation/" + id,
    method: "get",
  });
}

// 新增教师基础信息
export function addInformation(data) {
  return request({
    url: "/teacher/basiclnformation/add",
    method: "post",
    data: data,
  });
}

// 修改教师基础信息
export function updateInformation(data) {
  return request({
    url: "/teacher/basiclnformation/update",
    method: "put",
    data: data,
  });
}

// 删除教师基础信息
export function delInformation(id) {
  return request({
    url: "/teacher/basiclnformation/" + id,
    method: "delete",
  });
}
//导出接口
export function exportInformation(data) {
  return request({
    url: "/teacher/basiclnformation/export",
    method: "post",
    data: data,
  });
}
//学生照片导入
export function filesUpload(files) {
  return request({
    url: "/teacher/basiclnformation/importTeacherPicture",
    method: "post",
    data: files,
  });
}
