import request from '@/utils/request'

// 查询设备维修列表
export function listRecord(query) {
  return request({
    url: '/deviceRecord/list',
    method: 'get',
    params: query
  })
}

// 查询设备维修详细
export function getRecord(id) {
  return request({
    url: `/deviceRecord/queryById/${id}`,
    method: 'get'
  })
}

// 新增设备维修
export function addRecord(data) {
  return request({
    url: '/deviceRecord/add',
    method: 'post',
    data: data
  })
}

// 修改设备维修
export function updateRecord(data) {
  return request({
    url: '/deviceRecord/edit',
    method: 'put',
    data: data
  })
}

// 删除设备维修
export function delRecord(id) {
  return request({
    url: `/deviceRecord/deleteByIds/${id}`,
    method: 'delete'
  })
}

// 提交设备维修申请
export function submitApply(id) {
  return request({
    url: `/deviceRecord/submitApply/${id}`,
    method: 'post',
  })
}

// 待办 已办
// 查询设备维修待办
export function taskList(query) {
  return request({
    url: '/deviceRecord/taskList',
    method: 'get',
    params: query
  })
}

// 我的待办任务列表
export function myTaskList(query) {
  return request({
    url: '/deviceRecord/myTaskList',
    method: 'get',
    params: query
  })
}

// 查询设备维修已办
export function taskDoneList(query) {
  return request({
    url: '/deviceRecord/taskDoneList',
    method: 'get',
    params: query
  })
}

// 已完成
export function getComplete(taskId, instanceId) {
  return request({
    url: `/deviceRecord/complete/${taskId}/${instanceId}`,
    method: 'get',
    params: query
  })
}

// 处理任务
export function complete({taskId, instanceId, comment, pass}) {
  return request({
    url: `/deviceRecord/complete/${taskId}/${instanceId}`,
    method: 'post',
    data: {
      comment,
      pass
    }
  })
}
