import request from '@/utils/request'

// 查询设备管理列表
export function listDevice(query) {
  return request({
    url: '/device/list',
    method: 'get',
    params: query
  })
}

// 查询设备管理详细
export function getDevice(id) {
  return request({
    url: `/device/queryById/${id}`,
    method: 'get'
  })
}

// 新增设备管理
export function addDevice(data) {
  return request({
    url: '/device/add',
    method: 'post',
    data: data
  })
}

// 修改设备管理
export function updateDevice(data) {
  return request({
    url: '/device/edit',
    method: 'put',
    data: data
  })
}

// 删除设备管理
export function delDevice(ids) {
  return request({
    url: `/device/delete/${ids}`,
    method: 'delete',
  })
}

// 查询场地信息列表
export function listArea(queryParams) {
  return request({
    url: '/area/list',
    method: 'get',
    params: queryParams
  })
}
