import request from "@/utils/request";

//获取学年+学期
export function getNewYear(data) {
  return request({
    url: "/experimentPlan/getSemester",
    method: "get",
    data,
  });
}
// 查询级部
export function getGrade() {
  return request({
    url: "/experimentPlan/getGrade",
    method: "get",
  });
}
//获取级部下拉框(搜索条件);
export function getGradelist() {
  return request({
    url: "/experimentPlan/getGradeList",
    method: "get",
  });
}
//新增个人实验申请
export function addExperimentPlan(data) {
  return request({
    url: "/schoolTeacherExperimentApply/add",
    method: "post",
    data,
  });
}
// 修改个人实验申请
export function updateExperimentPlan(data) {
  return request({
    url: "/schoolTeacherExperimentApply/edit",
    method: "put",
    data,
  });
}
// 删除个人实验申请
export function deleteExperimentPlan(id) {
  return request({
    url: "/schoolTeacherExperimentApply/" + id,
    method: "post",
  });
}

// 查询个人实验申请列表
export function getApplylist(query) {
  return request({
    url: "/schoolTeacherExperimentApply/list",
    method: "get",
    params: query,
  });
}

//查看详情
export function getListxq(id) {
  return request({
    url: "/schoolTeacherExperimentApply/" + id,
    method: "get",
  });
}
//查看详情
export function getResult(data) {
  return request({
    url: "/schoolTeacherExperimentApply/experimentResult",
    method: "post",
    data,
  });
}
//获取科目
export function getSub() {
  return request({
    url: "schoolTeacherExperimentApply/getSubject",
    method: "get",
  });
}
