import request from "@/utils/request";

// 查询学生嘉奖列表(全部)
export function listStudentAward(query) {
  return request({
    url: "/school/studentAward/list",
    method: "get",
    params: query,
  });
}
// 查询学生嘉奖列表(个人)
export function listStudentAwardgr(query) {
  return request({
    url: "/school/studentAward/listGr",
    method: "get",
    params: query,
  });
}
// 查询学生嘉奖列表(已通过)
export function listStudentAwardtg(query) {
  return request({
    url: "/school/studentAward/listYtg",
    method: "get",
    params: query,
  });
}
// 查询学生嘉奖详细
export function getStudentAward(id) {
  return request({
    url: "/school/studentAward/" + id,
    method: "get",
  });
}

// 新增学生嘉奖(个人)
export function addStudentAwardgr(data) {
  return request({
    url: "/school/studentAward/addGr",
    method: "post",
    data: data,
  });
}
// 新增学生嘉奖(管理员)
export function addStudentAward(data) {
  return request({
    url: "/school/studentAward",
    method: "post",
    data: data,
  });
}
// 修改学生嘉奖
export function updateStudentAward(data) {
  return request({
    url: "/school/studentAward",
    method: "put",
    data: data,
  });
}

// 删除学生嘉奖
export function delStudentAward(id) {
  return request({
    url: "/school/studentAward/" + id,
    method: "delete",
  });
}
//提交审核
export function reviewStudentAward(data) {
  return request({
    url: "/school/studentAward/submit",
    method: "post",
    data: data,
  });
}
//班主任管理--学生嘉奖查看
export function listStudent(query) {
  return request({
    url: "/school/studentAward/getStudentAwardList",
    method: "get",
    params: query,
  });
}
//班主任管理--学生违纪查看
export function listStudentwj(query) {
  return request({
    url: "/school/discipline/getDisciplineList",
    method: "get",
    params: query,
  });
}
