import request from '@/utils/request'


// 查询校历详细条目列表
export function listSchoolCalendarDetail(query, calendarId) {
  return request({
    url: '/schoolCalendarDetail/list/' + calendarId,
    method: 'get',
    params: query
  })
}

// 查询校历详细条目详细
export function getSchoolCalendarDetail(id) {
  return request({
    url: '/schoolCalendarDetail/queryOne/' + id,
    method: 'get'
  })
}

// 新增校历详细条目
export function addSchoolCalendarDetail(data, calendarId) {
  return request({
    url: '/schoolCalendarDetail/add/' + calendarId,
    method: 'post',
    data: data
  })
}

// 修改校历详细条目
export function updateSchoolCalendarDetail(data, calendarId) {
  return request({
    url: '/schoolCalendarDetail/edit/' + calendarId,
    method: 'put',
    data: data
  })
}

// 删除校历详细条目
export function delSchoolCalendarDetail(ids) {
  return request({
    url: '/schoolCalendarDetail/remove/' + ids,
    method: 'delete',
  })
}

//按照年份来显示事件
export function selectListByYear(data, time) {
  return request({
    url: '/schoolCalendarDetail/selectAllYear/' + time,
    method: 'get',
    params: data
  })
}

// 传选中日期，返回事件
export function getThingListByTime(time) {
  return request({
    url: '/schoolCalendarDetail/select/' + time,
    method: 'get',
  })
}
