/**
 * @description 通用公共方法
 *
 */

import request from '@/utils/request';

// 通用上传方法
export function commonUpload(file, callback = null) {
  return request({
    url: 'common/upload',
    method: 'post',
    data: file,
    onUploadProgress: (progress) => {
      callback && callback(progress);
    }
  })
}
// 签名上传方法
export function signUpload(file, callback = null) {
  return request({
    url: 'common/sign',
    method: 'post',
    data: file,
    onUploadProgress: (progress) => {
      callback && callback(progress);
    }
  })
}

// 上传图片
export function uploadImage(file, callback = null) {
  return request({
    url: 'common/avatar',
    method: 'post',
    data: file,
    onUploadProgress: (progress) => {
      callback && callback(progress);
    }
  })
}
