package com.core.utils;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WeatherUtil {
    private static JSONObject cityJson=null;

    public static String cityAreaId(String city){
        if (cityJson==null){
            //获取出所有城市的AreaId
            JSONObject cityAreaId = getCity();
            cityJson=cityAreaId;
        }
        //取出对应城市的areaid
        String areaId = cityJson.getStr(city);
        if (areaId==null){
            throw new RuntimeException("该城市找不到AreaId");
        }
        return areaId;
    }
    /**
     * 获取所有城市AreaId
     * @return
     */
    public static JSONObject getCity(){
        String cityjs="https://j.i8tq.com/weather2020/search/city.js";
        //发送请求获取数据
        String cityStr = HttpUtil.createGet(cityjs).header("Referer", "http://www.weather.com.cn/").execute().body();
        //需要解析数据
        String cityJson = cityStr.replace("var city_data =", "");
        //创建集合存储数据
        //使用 NAMECN:AREAID
        Map<String, Long> map = new HashMap<>();
        JSONObject entries = JSONUtil.parseObj(cityJson);
        Set<String> keys = entries.keySet();
        for (String key : keys) {
//            System.out.println("第一层 省" + key);
            Set<String> citys = entries.getJSONObject(key).keySet();
            for (String city : citys) {
//                System.out.println("--第二层 城市" + city);
                Set<String> areas = entries.getJSONObject(key).getJSONObject(city).keySet();
                for (String area : areas) {
//                    System.out.println("---第三层 区:" + area);
                    JSONObject jsonObject = entries.getJSONObject(key).getJSONObject(city).getJSONObject(area);
//                    System.out.println(jsonObject.toString());
                    map.put(jsonObject.getStr("NAMECN"), jsonObject.getLong("AREAID"));
                }
            }
        }
        //把map数据转换成json
        String jsonStr = JSONUtil.toJsonStr(map);
//        System.out.println(jsonStr);
        return JSONUtil.parseObj(map);
    }

    /**
     * 获取实时城市天气
     * @param
     * @return
     */
    public static JSONObject getRealWeather(String city){
        //传过来的数据为XX市，查询时应去掉“市”，才可查出
        city = city.substring(0,city.length() - 1);
        //取出对应城市的areaid
        String areaId = cityAreaId(city);
        //实时天气的地址
        String REALWEATHER_URL="http://d1.weather.com.cn/sk_2d/";
        String uri=REALWEATHER_URL+areaId+".html";
        String res = HttpUtil.createGet(uri).timeout(10000).header("Referer", "http://www.weather.com.cn/").execute().body();
        //替换数据不然会影响json的解析
        String json = res.replace("var dataSK=", "");
        return JSONUtil.parseObj(json);
    }

    public static JSONObject getProWeather(String pro){
        //取出对应城市的areaid
        String areaId = cityAreaId(pro);
        //实时天气的地址
        String REALWEATHER_URL="http://d1.weather.com.cn/sk_2d/";
        //拼接请求地址
        // String uri=REALWEATHER_URL+areaId+".html";
        String uri=REALWEATHER_URL+areaId+".html";
        String res = HttpUtil.createGet(uri).timeout(10000).header("Referer", "http://www.weather.com.cn/").execute().body();
        //替换数据不然会影响json的解析
        String json = res.replace("var dataSK=", "");
        return JSONUtil.parseObj(json);
    }

    /**
     * 获取当天城市天气
     * @param city
     * @return
     */
    public static JSONObject getWeather(String city){
        //传过来的数据为XX市，查询时应去掉“市”
        city = city.substring(0,city.length() - 1);
        //取出对应城市的areaid
        String areaId = cityAreaId(city);
        String WEATHER_URL="http://d1.weather.com.cn/dingzhi/";
        String uri=WEATHER_URL+areaId+".html";
        String res = HttpUtil.createGet(uri).timeout(10000).header("Referer", "http://www.weather.com.cn/").execute().body();
        String resR = res.replace("var cityDZ"+areaId+" =", "");
        String[] split = resR.split(";");
        return JSONUtil.parseObj(split[0]).getJSONObject("weatherinfo");
    }

    /**
     * 天气生活助手: 天气指数
     * http://www.weather.com.cn/life/
     * @return
     */
    public static  JSONObject getWeatherZs(String city){
        String areaid = cityAreaId(city);
        String ZS_URL="http://d1.weather.com.cn/zs_index/";
        String uri=ZS_URL+areaid+".html";
        String res = HttpUtil.createGet(uri).timeout(10000).header("Referer", "http://www.weather.com.cn/").execute().body();
        String resR = res.replace("var dataZS=", "");
        return JSONUtil.parseObj(resR).getJSONObject("zs");
    }

}
