package com.core.exceptionHandler;


public class HandleException extends RuntimeException{

    private static final long serialVersionUID = 1L;

    /**
     * 错误码
     */
    private Integer code;

    /**
     * 错误提示
     */
    private String message;

    /**
     * 空构造方法，避免反序列化问题
     */
    public HandleException()
    {
    }

    public HandleException(String message)
    {
        this.message = message;
    }

    public HandleException(String message, Integer code)
    {
        this.message = message;
        this.code = code;
    }


    @Override
    public String getMessage()
    {
        return message;
    }

    public Integer getCode()
    {
        return code;
    }

    public HandleException setMessage(String message)
    {
        this.message = message;
        return this;
    }
}
