package com.ruoyi.project.zt.controller;

import cn.hutool.http.HttpRequest;
import com.google.gson.*;
import com.ruoyi.framework.util.JsonToMarkdown;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.project.zt.domian.CommonParam;
import com.ruoyi.project.zt.domian.DjDcInfo;
import com.ruoyi.project.zt.domian.Djjc;
import com.ruoyi.project.zt.domian.Ljinfo;
import com.ruoyi.project.zt.service.DjdcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/djdc")
public class DjdcController {




    @Autowired
    private DjdcService djdcService;


    @GetMapping("/getList")
    public AjaxResult getList(DjDcInfo info){
        return AjaxResult.success(djdcService.getList(info));
    }

    /**
     * 根据井号查询临井
     */
    @GetMapping("/ljListByJh")
    public AjaxResult ljListByJh(Ljinfo info){
        return AjaxResult.success(djdcService.ljListByJh(info));
    }



    /**
     * 获取井基础信息
     */
    @PostMapping("/api")
    public AjaxResult ff(@RequestBody CommonParam param){
        String path = param.getPath();
        Map<String,Object> map =new HashMap<>();
        switch (path) {
            case "getDjjcList":
                //获取邻井基础信息
                map.put("jh","井号");
                map.put("kc","开次");
                map.put("jd","井段");
                map.put("cw","层位");
                map.put("jc","进尺");
                map.put("jxzs","机械钻速");
                map.put("ztxh","钻头型号");
                map.put("pz","喷嘴");
                map.put("mxqk","磨损情况");
                map.put("qzyy","起钻原因");
                map.put("zb","指标");
                List<Djjc> djjcList = djdcService.getDjjcList(param);
                AjaxResult success = AjaxResult.success(djjcList, map);
                Gson gson = new GsonBuilder().setPrettyPrinting().create();

                // 将实体对象转换为JSON字符串
                String json = gson.toJson(success);
                String convert = JsonToMarkdown.convert(json);
                System.out.println(convert);
                return success;

            case "getZqshfxList":
                //获取邻井周期分析
                map.put("jh","井号");
                map.put("kc","开次");
                map.put("cw","层位");
                map.put("jc","进尺");
                map.put("zjzq","钻进周期");
                map.put("zwzq","中完周期");
                map.put("zjsl","钻进速率");
                map.put("zjycsl","钻进异常周期");
                map.put("wjycsl","完井异常周期");
                return AjaxResult.success( djdcService.getZqshfxList(param),map);
            case "getZjzhfxList":
                //获取钻具组合分析
                map.put("jh","井号");
                map.put("kc","开次");
                map.put("jd","井段");
                map.put("jc","进尺");
                map.put("zjzhmx","钻具组合模型");
                map.put("tsgj","特殊工具");
                map.put("zjzh","钻具组合明细");
                map.put("zb","时效");
                return AjaxResult.success( djdcService.getZjzhfxList(param),map);
            default:
                return AjaxResult.success();
        }
    }


    /**
     * 调用长城大模型
     * @param param
     * @return
     */
    @PostMapping("/dyAiModel")
    public AjaxResult dyAiModel(CommonParam param){

        Map<String,Object> map=new HashMap<>();
        map.put("prompt",param.getZjzh()+" 这是一个钻具组合信息，请把这个钻具组合信息拆分成竖表，字段为钻具名称(zjmc)、型号(xh)、长度(cd),最终输出json格式数据,其他内容不输出,输出内容不换行，只要数据，反斜杠不输出");

        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(map);

        String url="http://10.68.249.59:33331/api/chat/1";

        String result2 = HttpRequest.post(url)
                .body(json)
                .execute().body();
        System.out.println(result2);
        // 解析API响应
        Gson gsonres = new GsonBuilder().setPrettyPrinting().create();
        JsonObject apiResponse = JsonParser.parseString(result2).getAsJsonObject();

        // 提取message.content字段
        JsonObject message = apiResponse.getAsJsonObject("message");
        String content = message.get("content").getAsString();

        // 提取content中的JSON部分（去除Markdown代码块标记）
        String jsonContent = extractJsonContent(content);

        // 解析并格式化JSON内容
        JsonElement jsonElement = JsonParser.parseString(jsonContent);
        String formattedJson = gson.toJson(jsonElement);

        // 输出格式化后的JSON
        System.out.println(formattedJson);

        // 示例：处理解析后的数据
        JsonObject dataObject = JsonParser.parseString(jsonContent).getAsJsonObject();
        JsonArray dataArray = dataObject.getAsJsonArray("data");

        // 遍历数据数组
        for (JsonElement element : dataArray) {
            JsonObject item = element.getAsJsonObject();
            String zjmc = item.get("zjmc").getAsString();
            String xh = item.get("xh").getAsString();
            String cd = item.get("cd").getAsString();
            System.out.printf("组件名称: %s, 型号: %s, 长度: %s%n", zjmc, xh, cd);
        }


        return AjaxResult.success();
    }



    /**
     * 从Markdown代码块中提取JSON内容
     */
    private static String extractJsonContent(String markdownContent) {
        // 去除开头的```json和结尾的```
        return markdownContent
                .replaceFirst("^```json", "")
                .replaceFirst("```$", "")
                .trim();
    }





}
