package com.zjsgfa.project.zjsgfa.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

import cn.hutool.core.codec.Base64;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.StringUtils;
import com.zjsgfa.framework.util.RichTextProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjJkzpMapper;
import com.zjsgfa.project.zjsgfa.domain.SjJkzp;
import com.zjsgfa.project.zjsgfa.service.ISjJkzpService;

/**
 * 设计-井控专篇Service业务层处理
 * 
 * @author
 * @date 2025-07-24
 */
@Service
public class SjJkzpServiceImpl implements ISjJkzpService 
{
    @Autowired
    private SjJkzpMapper sjJkzpMapper;

    /**
     * 查询设计-井控专篇
     * 
     * @param id 设计-井控专篇主键
     * @return 设计-井控专篇
     */
    @Override
    public SjJkzp selectSjJkzpById(Long id)
    {
        SjJkzp sjJkzp = sjJkzpMapper.selectSjJkzpById(id);
        // 压缩富文本中的图片，设置质量和最大尺寸
        String compressedContent = RichTextProcessor.processRichText(
                sjJkzp.getZjkzz(),  // 你的富文本字段
                0.7f,  // 质量 0.0-1.0
                800,   // 最大宽度
                600    // 最大高度
        );

        // 设置压缩后的富文本
        sjJkzp.setZjkzz(compressedContent);


        String clcb = RichTextProcessor.processRichText(
                sjJkzp.getClcb(),  // 你的富文本字段
                0.7f,  // 质量 0.0-1.0
                800,   // 最大宽度
                600    // 最大高度
        );

        // 设置压缩后的富文本
        sjJkzp.setClcb(clcb);


        String jlgh = RichTextProcessor.processRichText(
                sjJkzp.getJlgh(),  // 你的富文本字段
                0.7f,  // 质量 0.0-1.0
                800,   // 最大宽度
                600    // 最大高度
        );

        // 设置压缩后的富文本
        sjJkzp.setJlgh(jlgh);

        String syyq = RichTextProcessor.processRichText(
                sjJkzp.getSyyq(),  // 你的富文本字段
                0.7f,  // 质量 0.0-1.0
                800,   // 最大宽度
                600    // 最大高度
        );

        // 设置压缩后的富文本
        sjJkzp.setSyyq(syyq);
        return sjJkzp;
    }

    /**
     * 查询设计-井控专篇列表
     * 
     * @param sjJkzp 设计-井控专篇
     * @return 设计-井控专篇
     */
    @Override
    public List<SjJkzp> selectSjJkzpList(SjJkzp sjJkzp)
    {
        List<SjJkzp> list = sjJkzpMapper.selectSjJkzpList(sjJkzp);
        list.stream().map(entity -> {
            // 压缩富文本中的图片，设置质量和最大尺寸
            String compressedContent = RichTextProcessor.processRichText(
                    entity.getZjkzz(),  // 你的富文本字段
                    0.7f,  // 质量 0.0-1.0
                    800,   // 最大宽度
                    600    // 最大高度
            );

            // 设置压缩后的富文本
            entity.setZjkzz(compressedContent);


            String clcb = RichTextProcessor.processRichText(
                    entity.getClcb(),  // 你的富文本字段
                    0.7f,  // 质量 0.0-1.0
                    800,   // 最大宽度
                    600    // 最大高度
            );

            // 设置压缩后的富文本
            entity.setClcb(clcb);


            String jlgh = RichTextProcessor.processRichText(
                    entity.getJlgh(),  // 你的富文本字段
                    0.7f,  // 质量 0.0-1.0
                    800,   // 最大宽度
                    600    // 最大高度
            );

            // 设置压缩后的富文本
            entity.setJlgh(jlgh);

            String syyq = RichTextProcessor.processRichText(
                    entity.getSyyq(),  // 你的富文本字段
                    0.7f,  // 质量 0.0-1.0
                    800,   // 最大宽度
                    600    // 最大高度
            );

            // 设置压缩后的富文本
            entity.setSyyq(syyq);
            return entity;
        }).collect(Collectors.toList());
        return list;
    }

    /**
     * 新增设计-井控专篇
     * 
     * @param sjJkzp 设计-井控专篇
     * @return 结果
     */
    @Override
    public int insertSjJkzp(SjJkzp sjJkzp)
    {
        if(StringUtils.isNotEmpty(sjJkzp.getZjkzz())){
            sjJkzp.setZjkzz(new String(Base64.decode(sjJkzp.getZjkzz()), StandardCharsets.UTF_8));
        }
        if(StringUtils.isNotEmpty(sjJkzp.getClcb())){
            sjJkzp.setClcb(new String(Base64.decode(sjJkzp.getClcb()), StandardCharsets.UTF_8));
        }
        if(StringUtils.isNotEmpty(sjJkzp.getJlgh())){
            sjJkzp.setJlgh(new String(Base64.decode(sjJkzp.getJlgh()), StandardCharsets.UTF_8));

        }
        if(StringUtils.isNotEmpty(sjJkzp.getSyyq())){
            sjJkzp.setSyyq(new String(Base64.decode(sjJkzp.getSyyq()), StandardCharsets.UTF_8));
        }
        return sjJkzpMapper.insertSjJkzp(sjJkzp);
    }

    /**
     * 修改设计-井控专篇
     * 
     * @param sjJkzp 设计-井控专篇
     * @return 结果
     */
    @Override
    public int updateSjJkzp(SjJkzp sjJkzp)
    {
        if(StringUtils.isNotEmpty(sjJkzp.getZjkzz())){
            sjJkzp.setZjkzz(new String(Base64.decode(sjJkzp.getZjkzz()), StandardCharsets.UTF_8));
        }
        if(StringUtils.isNotEmpty(sjJkzp.getClcb())){
            sjJkzp.setClcb(new String(Base64.decode(sjJkzp.getClcb()), StandardCharsets.UTF_8));
        }
        if(StringUtils.isNotEmpty(sjJkzp.getJlgh())){
            sjJkzp.setJlgh(new String(Base64.decode(sjJkzp.getJlgh()), StandardCharsets.UTF_8));

        }
        if(StringUtils.isNotEmpty(sjJkzp.getSyyq())){
            sjJkzp.setSyyq(new String(Base64.decode(sjJkzp.getSyyq()), StandardCharsets.UTF_8));
        }
        sjJkzp.setUpdateTime(DateUtils.getNowDate());
        return sjJkzpMapper.updateSjJkzp(sjJkzp);
    }

    /**
     * 批量删除设计-井控专篇
     * 
     * @param ids 需要删除的设计-井控专篇主键
     * @return 结果
     */
    @Override
    public int deleteSjJkzpByIds(Long[] ids)
    {
        return sjJkzpMapper.deleteSjJkzpByIds(ids);
    }

    /**
     * 删除设计-井控专篇信息
     * 
     * @param id 设计-井控专篇主键
     * @return 结果
     */
    @Override
    public int deleteSjJkzpById(Long id)
    {
        return sjJkzpMapper.deleteSjJkzpById(id);
    }
}
