package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjFdsgcsDcylZjymdsjbMapper;
import com.zjsgfa.project.zjsgfa.domain.SjFdsgcsDcylZjymdsjb;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsDcylZjymdsjbService;

/**
 * 邻井钻井液密度数据Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-04
 */
@Service
public class SjFdsgcsDcylZjymdsjbServiceImpl implements ISjFdsgcsDcylZjymdsjbService 
{
    @Autowired
    private SjFdsgcsDcylZjymdsjbMapper sjFdsgcsDcylZjymdsjbMapper;

    /**
     * 查询邻井钻井液密度数据
     * 
     * @param id 邻井钻井液密度数据主键
     * @return 邻井钻井液密度数据
     */
    @Override
    public SjFdsgcsDcylZjymdsjb selectSjFdsgcsDcylZjymdsjbById(Long id)
    {
        return sjFdsgcsDcylZjymdsjbMapper.selectSjFdsgcsDcylZjymdsjbById(id);
    }

    /**
     * 查询邻井钻井液密度数据列表
     * 
     * @param sjFdsgcsDcylZjymdsjb 邻井钻井液密度数据
     * @return 邻井钻井液密度数据
     */
    @Override
    public List<SjFdsgcsDcylZjymdsjb> selectSjFdsgcsDcylZjymdsjbList(SjFdsgcsDcylZjymdsjb sjFdsgcsDcylZjymdsjb)
    {
        return sjFdsgcsDcylZjymdsjbMapper.selectSjFdsgcsDcylZjymdsjbList(sjFdsgcsDcylZjymdsjb);
    }

    /**
     * 新增邻井钻井液密度数据
     * 
     * @param sjFdsgcsDcylZjymdsjb 邻井钻井液密度数据
     * @return 结果
     */
    @Override
    public int insertSjFdsgcsDcylZjymdsjb(SjFdsgcsDcylZjymdsjb sjFdsgcsDcylZjymdsjb)
    {
        sjFdsgcsDcylZjymdsjb.setCreateTime(DateUtils.getNowDate());
        return sjFdsgcsDcylZjymdsjbMapper.insertSjFdsgcsDcylZjymdsjb(sjFdsgcsDcylZjymdsjb);
    }

    /**
     * 修改邻井钻井液密度数据
     * 
     * @param sjFdsgcsDcylZjymdsjb 邻井钻井液密度数据
     * @return 结果
     */
    @Override
    public int updateSjFdsgcsDcylZjymdsjb(SjFdsgcsDcylZjymdsjb sjFdsgcsDcylZjymdsjb)
    {
        return sjFdsgcsDcylZjymdsjbMapper.updateSjFdsgcsDcylZjymdsjb(sjFdsgcsDcylZjymdsjb);
    }

    /**
     * 批量删除邻井钻井液密度数据
     * 
     * @param ids 需要删除的邻井钻井液密度数据主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsDcylZjymdsjbByIds(Long[] ids)
    {
        return sjFdsgcsDcylZjymdsjbMapper.deleteSjFdsgcsDcylZjymdsjbByIds(ids);
    }

    /**
     * 删除邻井钻井液密度数据信息
     * 
     * @param id 邻井钻井液密度数据主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsDcylZjymdsjbById(Long id)
    {
        return sjFdsgcsDcylZjymdsjbMapper.deleteSjFdsgcsDcylZjymdsjbById(id);
    }
}
