package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-井眼轨迹_轨道设计各点参数对象 sj_jygj_gdsjgdcs
 * 
 * @author
 * @date 2025-06-26
 */
@Data
public class SjJygjGdsjgdcs extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 井深 */
    @Excel(name = "井深")
    private Double js;

    /** 井斜 */
    @Excel(name = "井斜")
    private Double jx;

    /** 方位 */
    @Excel(name = "方位")
    private Double fw;

    /** 闭合方位 */
    @Excel(name = "闭合方位")
    private Double bhfw;

    /** 垂深 */
    @Excel(name = "垂深")
    private Double cs;

    /** 闭合距 */
    @Excel(name = "闭合距")
    private Double bhj;

    /** 南北位移 */
    @Excel(name = "南北位移")
    private Double nbwy;

    /** 东西位移 */
    @Excel(name = "东西位移")
    private Double dxwy;

    /** 造斜率 */
    @Excel(name = "造斜率")
    private Double zxl;

    /** 方位变化率 */
    @Excel(name = "方位变化率")
    private Double fwbhl;

    /** 全角变化率 */
    @Excel(name = "全角变化率")
    private Double qjbhl;

    /** 工具面 */
    @Excel(name = "工具面")
    private Double gjm;

    @Excel(name = "视平移")
    private Double spy;


    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

}
