package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjHse;
import com.zjsgfa.project.zjsgfa.service.ISjHseService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-HSE专篇Controller
 * 
 * @author
 * @date 2025-07-24
 */
@RestController
@RequestMapping("/system/sjHse")
public class SjHseController extends BaseController
{
    @Autowired
    private ISjHseService sjHseService;

    /**
     * 查询设计-HSE专篇列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjHse:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjHse sjHse)
    {
        startPage();
        List<SjHse> list = sjHseService.selectSjHseList(sjHse);
        return getDataTable(list);
    }

    @GetMapping("/getInfo")
    public AjaxResult getInfo(SjHse sjHse)
    {
        List<SjHse> sjHses = sjHseService.selectSjHseList(sjHse);
        SjHse vo= new SjHse();
        if(sjHses.size()>0){
            vo=sjHses.get(0);
        }
        return AjaxResult.success(vo);
    }

    /**
     * 导出设计-HSE专篇列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjHse:export')")
    @Log(title = "设计-HSE专篇", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjHse sjHse)
    {
        List<SjHse> list = sjHseService.selectSjHseList(sjHse);
        ExcelUtil<SjHse> util = new ExcelUtil<SjHse>(SjHse.class);
        util.exportExcel(response, list, "设计-HSE专篇数据");
    }

    /**
     * 获取设计-HSE专篇详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjHse:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjHseService.selectSjHseById(id));
    }

    /**
     * 新增设计-HSE专篇
     */
    //@PreAuthorize("@ss.hasPermi('system:sjHse:add')")
    @Log(title = "设计-HSE专篇", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjHse sjHse)
    {
        return toAjax(sjHseService.insertSjHse(sjHse));
    }

    /**
     * 修改设计-HSE专篇
     */
    //@PreAuthorize("@ss.hasPermi('system:sjHse:edit')")
    @Log(title = "设计-HSE专篇", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjHse sjHse)
    {
        return toAjax(sjHseService.updateSjHse(sjHse));
    }

    /**
     * 删除设计-HSE专篇
     */
    //@PreAuthorize("@ss.hasPermi('system:sjHse:remove')")
    @Log(title = "设计-HSE专篇", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjHseService.deleteSjHseByIds(ids));
    }
}
