package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.MxfxjgbTsc;
import com.zjsgfa.project.zjsgfa.service.IMxfxjgbTscService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 大模型分析-提示词Controller
 * 
 * @author ruoyi
 * @date 2025-12-11
 */
@RestController
@RequestMapping("/system/mxfxjgbTsc")
public class MxfxjgbTscController extends BaseController
{
    @Autowired
    private IMxfxjgbTscService mxfxjgbTscService;

    /**
     * 查询大模型分析-提示词列表
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgbTsc:list')")
    @GetMapping("/list")
    public TableDataInfo list(MxfxjgbTsc mxfxjgbTsc)
    {
        startPage();
        List<MxfxjgbTsc> list = mxfxjgbTscService.selectMxfxjgbTscList(mxfxjgbTsc);
        return getDataTable(list);
    }

    /**
     * 导出大模型分析-提示词列表
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgbTsc:export')")
    @Log(title = "大模型分析-提示词", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MxfxjgbTsc mxfxjgbTsc)
    {
        List<MxfxjgbTsc> list = mxfxjgbTscService.selectMxfxjgbTscList(mxfxjgbTsc);
        ExcelUtil<MxfxjgbTsc> util = new ExcelUtil<MxfxjgbTsc>(MxfxjgbTsc.class);
        util.exportExcel(response, list, "大模型分析-提示词数据");
    }

    /**
     * 获取大模型分析-提示词详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgbTsc:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(mxfxjgbTscService.selectMxfxjgbTscById(id));
    }

    /**
     * 新增大模型分析-提示词
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgbTsc:add')")
    @Log(title = "大模型分析-提示词", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MxfxjgbTsc mxfxjgbTsc)
    {
        return toAjax(mxfxjgbTscService.insertMxfxjgbTsc(mxfxjgbTsc));
    }

    /**
     * 修改大模型分析-提示词
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgbTsc:edit')")
    @Log(title = "大模型分析-提示词", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MxfxjgbTsc mxfxjgbTsc)
    {
        return toAjax(mxfxjgbTscService.updateMxfxjgbTsc(mxfxjgbTsc));
    }

    /**
     * 删除大模型分析-提示词
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgbTsc:remove')")
    @Log(title = "大模型分析-提示词", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(mxfxjgbTscService.deleteMxfxjgbTscByIds(ids));
    }
}
