package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjZlyqXx;
import com.zjsgfa.project.zjsgfa.service.ISjZlyqXxService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-井身质量要求详细Controller
 * 
 * @author
 * @date 2025-07-17
 */
@RestController
@RequestMapping("/system/sjZlyqXx")
public class SjZlyqXxController extends BaseController
{
    @Autowired
    private ISjZlyqXxService sjZlyqXxService;

    /**
     * 查询设计信息-井身质量要求详细列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqXx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZlyqXx sjZlyqXx)
    {
//        startPage();
        List<SjZlyqXx> list = sjZlyqXxService.selectSjZlyqXxList(sjZlyqXx);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-井身质量要求详细列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqXx:export')")
    @Log(title = "设计信息-井身质量要求详细", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZlyqXx sjZlyqXx)
    {
        List<SjZlyqXx> list = sjZlyqXxService.selectSjZlyqXxList(sjZlyqXx);
        ExcelUtil<SjZlyqXx> util = new ExcelUtil<SjZlyqXx>(SjZlyqXx.class);
        util.exportExcel(response, list, "设计信息-井身质量要求详细数据");
    }

    /**
     * 获取设计信息-井身质量要求详细详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqXx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZlyqXxService.selectSjZlyqXxById(id));
    }

    /**
     * 新增设计信息-井身质量要求详细
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqXx:add')")
    @Log(title = "设计信息-井身质量要求详细", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZlyqXx sjZlyqXx)
    {
        return toAjax(sjZlyqXxService.insertSjZlyqXx(sjZlyqXx));
    }

    /**
     * 修改设计信息-井身质量要求详细
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqXx:edit')")
    @Log(title = "设计信息-井身质量要求详细", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZlyqXx sjZlyqXx)
    {
        return toAjax(sjZlyqXxService.updateSjZlyqXx(sjZlyqXx));
    }

    /**
     * 删除设计信息-井身质量要求详细
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqXx:remove')")
    @Log(title = "设计信息-井身质量要求详细", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZlyqXxService.deleteSjZlyqXxByIds(ids));
    }
}
