package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import java.util.Map;

import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjJsjgMapper;
import com.ruoyi.project.zjsgfa.domain.SjJsjg;
import com.ruoyi.project.zjsgfa.service.ISjJsjgService;

/**
 * 设计信息-井身结构Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-06-24
 */
@Service
public class SjJsjgServiceImpl implements ISjJsjgService 
{
    @Autowired
    private SjJsjgMapper sjJsjgMapper;

    /**
     * 查询设计信息-井身结构
     * 
     * @param id 设计信息-井身结构主键
     * @return 设计信息-井身结构
     */
    @Override
    public SjJsjg selectSjJsjgById(Long id)
    {
        return sjJsjgMapper.selectSjJsjgById(id);
    }

    /**
     * 查询设计信息-井身结构列表
     * 
     * @param sjJsjg 设计信息-井身结构
     * @return 设计信息-井身结构
     */
    @Override
    public List<SjJsjg> selectSjJsjgList(SjJsjg sjJsjg)
    {
        return sjJsjgMapper.selectSjJsjgList(sjJsjg);
    }

    /**
     * 新增设计信息-井身结构
     * 
     * @param sjJsjg 设计信息-井身结构
     * @return 结果
     */
    @Override
    public int insertSjJsjg(SjJsjg sjJsjg)
    {
        return sjJsjgMapper.insertSjJsjg(sjJsjg);
    }

    /**
     * 修改设计信息-井身结构
     * 
     * @param sjJsjg 设计信息-井身结构
     * @return 结果
     */
    @Override
    public int updateSjJsjg(SjJsjg sjJsjg)
    {
        sjJsjg.setUpdateTime(DateUtils.getNowDate());
        return sjJsjgMapper.updateSjJsjg(sjJsjg);
    }

    /**
     * 批量删除设计信息-井身结构
     * 
     * @param ids 需要删除的设计信息-井身结构主键
     * @return 结果
     */
    @Override
    public int deleteSjJsjgByIds(Long[] ids)
    {
        return sjJsjgMapper.deleteSjJsjgByIds(ids);
    }

    /**
     * 删除设计信息-井身结构信息
     * 
     * @param id 设计信息-井身结构主键
     * @return 结果
     */
    @Override
    public int deleteSjJsjgById(Long id)
    {
        return sjJsjgMapper.deleteSjJsjgById(id);
    }

    @Override
    public Map selectJsjgt(SjJsjg sjJsjg) {

        List<SjJsjg> sjJsjgs = sjJsjgMapper.selectSjJsjgList(sjJsjg);



        return null;
    }
}
