package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjDjjcMapper;
import com.ruoyi.project.zjsgfa.domain.SjDjjc;
import com.ruoyi.project.zjsgfa.service.ISjDjjcService;

/**
 * 设计信息-井基础信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-06-23
 */
@Service
public class SjDjjcServiceImpl implements ISjDjjcService 
{
    @Autowired
    private SjDjjcMapper sjDjjcMapper;

    /**
     * 查询设计信息-井基础信息
     * 
     * @param id 设计信息-井基础信息主键
     * @return 设计信息-井基础信息
     */
    @Override
    public SjDjjc selectSjDjjcById(Long id)
    {
        return sjDjjcMapper.selectSjDjjcById(id);
    }

    /**
     * 查询设计信息-井基础信息列表
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 设计信息-井基础信息
     */
    @Override
    public List<SjDjjc> selectSjDjjcList(SjDjjc sjDjjc)
    {
        return sjDjjcMapper.selectSjDjjcList(sjDjjc);
    }

    /**
     * 新增设计信息-井基础信息
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 结果
     */
    @Override
    public int insertSjDjjc(SjDjjc sjDjjc)
    {
        return sjDjjcMapper.insertSjDjjc(sjDjjc);
    }

    /**
     * 修改设计信息-井基础信息
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 结果
     */
    @Override
    public int updateSjDjjc(SjDjjc sjDjjc)
    {
        sjDjjc.setUpdateTime(DateUtils.getNowDate());
        return sjDjjcMapper.updateSjDjjc(sjDjjc);
    }

    /**
     * 批量删除设计信息-井基础信息
     * 
     * @param ids 需要删除的设计信息-井基础信息主键
     * @return 结果
     */
    @Override
    public int deleteSjDjjcByIds(Long[] ids)
    {
        return sjDjjcMapper.deleteSjDjjcByIds(ids);
    }

    /**
     * 删除设计信息-井基础信息信息
     * 
     * @param id 设计信息-井基础信息主键
     * @return 结果
     */
    @Override
    public int deleteSjDjjcById(Long id)
    {
        return sjDjjcMapper.deleteSjDjjcById(id);
    }
}
