package com.ruoyi.project.zjsgfa.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 设计信息-井身结构对象 sj_jsjg
 * 
 * @author ruoyi
 * @date 2025-06-24
 */
public class SjJsjg extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 开次 */
    @Excel(name = "开次")
    private String kc;

    /** 钻头直径 */
    @Excel(name = "钻头直径")
    private BigDecimal ztzj;

    /** 井深 */
    @Excel(name = "井深")
    private BigDecimal js;

    /** 套管外径 */
    @Excel(name = "套管外径")
    private BigDecimal ttwj;

    /** 套管顶深 */
    @Excel(name = "套管顶深")
    private BigDecimal ttds;

    /** 套管下深 */
    @Excel(name = "套管下深")
    private BigDecimal ttxs;

    /** 水泥返高 */
    @Excel(name = "水泥返高")
    private BigDecimal snfg;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setKc(String kc) 
    {
        this.kc = kc;
    }

    public String getKc() 
    {
        return kc;
    }

    public void setZtzj(BigDecimal ztzj) 
    {
        this.ztzj = ztzj;
    }

    public BigDecimal getZtzj() 
    {
        return ztzj;
    }

    public void setJs(BigDecimal js) 
    {
        this.js = js;
    }

    public BigDecimal getJs() 
    {
        return js;
    }

    public void setTtwj(BigDecimal ttwj) 
    {
        this.ttwj = ttwj;
    }

    public BigDecimal getTtwj() 
    {
        return ttwj;
    }

    public void setTtds(BigDecimal ttds) 
    {
        this.ttds = ttds;
    }

    public BigDecimal getTtds() 
    {
        return ttds;
    }

    public void setTtxs(BigDecimal ttxs) 
    {
        this.ttxs = ttxs;
    }

    public BigDecimal getTtxs() 
    {
        return ttxs;
    }

    public void setSnfg(BigDecimal snfg) 
    {
        this.snfg = snfg;
    }

    public BigDecimal getSnfg() 
    {
        return snfg;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("kc", getKc())
            .append("ztzj", getZtzj())
            .append("js", getJs())
            .append("ttwj", getTtwj())
            .append("ttds", getTtds())
            .append("ttxs", getTtxs())
            .append("snfg", getSnfg())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
