package com.ruoyi.project.zjsgfa.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 设计信息-井基础信息对象 sj_djjc
 * 
 * @author ruoyi
 * @date 2025-06-23
 */
public class SjDjjc extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 井别 */
    @Excel(name = "井别")
    private String jb;

    /** 井型 */
    @Excel(name = "井型")
    private String jx;

    /** 井口横坐标 */
    @Excel(name = "井口横坐标")
    private Double jkhzb;

    /** 井口纵坐标 */
    @Excel(name = "井口纵坐标")
    private Double jkzzb;

    /** 构造位置 */
    @Excel(name = "构造位置")
    private String gzwz;

    /** 完钻层位 */
    @Excel(name = "完钻层位")
    private String wzcw;

    /** 钻探目的 */
    @Excel(name = "钻探目的")
    private String ztmd;

    /** 完钻原则 */
    @Excel(name = "完钻原则")
    private String wzyz;

    /** 完井方法 */
    @Excel(name = "完井方法")
    private String wjfa;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setJb(String jb) 
    {
        this.jb = jb;
    }

    public String getJb() 
    {
        return jb;
    }

    public void setJx(String jx) 
    {
        this.jx = jx;
    }

    public String getJx() 
    {
        return jx;
    }

    public void setJkhzb(Double jkhzb)
    {
        this.jkhzb = jkhzb;
    }

    public Double getJkhzb()
    {
        return jkhzb;
    }

    public void setJkzzb(Double jkzzb)
    {
        this.jkzzb = jkzzb;
    }

    public Double getJkzzb()
    {
        return jkzzb;
    }

    public void setGzwz(String gzwz) 
    {
        this.gzwz = gzwz;
    }

    public String getGzwz() 
    {
        return gzwz;
    }

    public void setWzcw(String wzcw) 
    {
        this.wzcw = wzcw;
    }

    public String getWzcw() 
    {
        return wzcw;
    }

    public void setZtmd(String ztmd) 
    {
        this.ztmd = ztmd;
    }

    public String getZtmd() 
    {
        return ztmd;
    }

    public void setWzyz(String wzyz) 
    {
        this.wzyz = wzyz;
    }

    public String getWzyz() 
    {
        return wzyz;
    }

    public void setWjfa(String wjfa) 
    {
        this.wjfa = wjfa;
    }

    public String getWjfa() 
    {
        return wjfa;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("jb", getJb())
            .append("jx", getJx())
            .append("jkhzb", getJkhzb())
            .append("jkzzb", getJkzzb())
            .append("gzwz", getGzwz())
            .append("wzcw", getWzcw())
            .append("ztmd", getZtmd())
            .append("wzyz", getWzyz())
            .append("wjfa", getWjfa())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
