package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson2.JSONObject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjJsjg;
import com.ruoyi.project.zjsgfa.service.ISjJsjgService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计信息-井身结构Controller
 * 
 * @author ruoyi
 * @date 2025-06-24
 */
@RestController
@RequestMapping("/system/sjJsjg")
public class SjJsjgController extends BaseController
{
    @Autowired
    private ISjJsjgService sjJsjgService;

    /**
     * 查询设计信息-井身结构列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjJsjg:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjJsjg sjJsjg)
    {
        startPage();
        List<SjJsjg> list = sjJsjgService.selectSjJsjgList(sjJsjg);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-井身结构列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjJsjg:export')")
    @Log(title = "设计信息-井身结构", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjJsjg sjJsjg)
    {
        List<SjJsjg> list = sjJsjgService.selectSjJsjgList(sjJsjg);
        ExcelUtil<SjJsjg> util = new ExcelUtil<SjJsjg>(SjJsjg.class);
        util.exportExcel(response, list, "设计信息-井身结构数据");
    }

    /**
     * 获取设计信息-井身结构详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:sjJsjg:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjJsjgService.selectSjJsjgById(id));
    }

    /**
     * 新增设计信息-井身结构
     */
    @PreAuthorize("@ss.hasPermi('system:sjJsjg:add')")
    @Log(title = "设计信息-井身结构", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjJsjg sjJsjg)
    {
        return toAjax(sjJsjgService.insertSjJsjg(sjJsjg));
    }

    /**
     * 修改设计信息-井身结构
     */
    @PreAuthorize("@ss.hasPermi('system:sjJsjg:edit')")
    @Log(title = "设计信息-井身结构", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjJsjg sjJsjg)
    {
        return toAjax(sjJsjgService.updateSjJsjg(sjJsjg));
    }

    /**
     * 删除设计信息-井身结构
     */
    @PreAuthorize("@ss.hasPermi('system:sjJsjg:remove')")
    @Log(title = "设计信息-井身结构", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjJsjgService.deleteSjJsjgByIds(ids));
    }






    /**
     * 查询井身结构图
     */
    @GetMapping("/jsjgt")
    public String  jsjgt(SjJsjg sjJsjg)
    {

        Map jsjgt = sjJsjgService.selectJsjgt(sjJsjg);
        JSONObject jsonObject = new JSONObject(jsjgt);
        String jsonString = jsonObject.toJSONString();
        return jsonString;
    }



}
