package com.ruoyi.project.zjsgfa.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.utils.StringUtils;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.http.MediaType;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjDjjc;
import com.ruoyi.project.zjsgfa.service.ISjDjjcService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 设计信息-井基础信息Controller
 * 
 * @author ruoyi
 * @date 2025-06-23
 */
@RestController
@RequestMapping("/designInformation/sjDjjc")
public class SjDjjcController extends BaseController
{
    @Autowired
    private ISjDjjcService sjDjjcService;

    /**
     * 查询设计信息-井基础信息列表
     */
    @PreAuthorize("@ss.hasPermi('designInformation:sjDjjc:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjDjjc sjDjjc)
    {
        startPage();
        List<SjDjjc> list = sjDjjcService.selectSjDjjcList(sjDjjc);
        return getDataTable(list);
    }

    /**
     * 获取井号下拉框
     * @param sjDjjc
     * @return
     */
    @GetMapping("/selectList")
    public AjaxResult selectList(SjDjjc sjDjjc)
    {
        List<SjDjjc> list = sjDjjcService.selectSjDjjcList(sjDjjc);
        return AjaxResult.success(list);
    }


    /**
     * 导出设计信息-井基础信息列表
     */
    @PreAuthorize("@ss.hasPermi('designInformation:sjDjjc:export')")
    @Log(title = "设计信息-井基础信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjDjjc sjDjjc)
    {
        List<SjDjjc> list = sjDjjcService.selectSjDjjcList(sjDjjc);
        ExcelUtil<SjDjjc> util = new ExcelUtil<SjDjjc>(SjDjjc.class);
        util.exportExcel(response, list, "设计信息-井基础信息数据");
    }

    /**
     * 获取设计信息-井基础信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('designInformation:sjDjjc:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjDjjcService.selectSjDjjcById(id));
    }

    /**
     * 新增设计信息-井基础信息
     */
    @PreAuthorize("@ss.hasPermi('designInformation:sjDjjc:add')")
    @Log(title = "设计信息-井基础信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjDjjc sjDjjc)
    {
        return toAjax(sjDjjcService.insertSjDjjc(sjDjjc));
    }

    /**
     * 修改设计信息-井基础信息
     */
    @PreAuthorize("@ss.hasPermi('designInformation:sjDjjc:edit')")
    @Log(title = "设计信息-井基础信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjDjjc sjDjjc)
    {
        return toAjax(sjDjjcService.updateSjDjjc(sjDjjc));
    }

    /**
     * 删除设计信息-井基础信息
     */
    @PreAuthorize("@ss.hasPermi('designInformation:sjDjjc:remove')")
    @Log(title = "设计信息-井基础信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjDjjcService.deleteSjDjjcByIds(ids));
    }



    /**
     * 下载导入模板
     */
    @RequestMapping(value = "/downdrmb", method = {RequestMethod.GET, RequestMethod.POST})
    public void export(HttpServletResponse response)throws IOException {
        Workbook exl = null;
        OutputStream out = null;
        InputStream in  = null;
        try {
            in =this.getClass().getResourceAsStream("/static/excel/sjdjjcdrmb.xlsx");
            exl = WorkbookFactory.create(in);
            out = response.getOutputStream();
            response.reset();
            String filename = URLEncoder.encode("导入模板.xlsx", "UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + filename);
            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);

            Sheet sheet = exl.getSheet("Sheet1");
            CellStyle cellStyle = exl.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
            cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
            cellStyle.setBorderTop(BorderStyle.THIN);//上边框
            cellStyle.setBorderRight(BorderStyle.THIN);//右边框
            cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
            Font cellFont = exl.createFont();
            cellFont.setFontHeightInPoints((short)9);    // 字体大小
            cellFont.setFontName("宋体");             // 字体应用到当前单元格上
            cellStyle.setFont(cellFont);
            cellStyle.setWrapText(true);//设置自动换行

            exl.write(out);
            exl.close();
        }catch (Exception e){
            e.getMessage();
            throw new IOException();
        }finally{
            if (exl != null) {
                try {
                    exl.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }



    /**
     * 导入数据
     */
    @PreAuthorize("@ss.hasPermi('designInformation:sjDjjc:importData')")
    @PostMapping("/importData")
    @ResponseBody
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception
    {
        XSSFWorkbook workbook = null;
        try {
            //装载流
            workbook = new XSSFWorkbook(file.getInputStream());
            // 获取一个工作表，下标从0开始
            XSSFSheet sheet = workbook.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            // 通过循环，逐行取出表中每行数据

            for(int i=0;i<=lastRowNum;i++){//跳过第一行
                if(i==0){
                    continue;
                }
                // 获取行
                XSSFRow row = sheet.getRow(i);
                System.out.println(row);
                SjDjjc info=new SjDjjc();

                String jh=new DataFormatter().formatCellValue(row.getCell(0));
                if(StringUtils.isEmpty(jh)){
                    return AjaxResult.error("第"+(i+1)+"行井号不能为空");
                }
                info.setJh(jh);

                String jb=new DataFormatter().formatCellValue(row.getCell(1));
                if(StringUtils.isEmpty(jb)){
                    return AjaxResult.error("第"+(i+1)+"行井别不能为空");
                }
                info.setJb(jb);

                String jx=new DataFormatter().formatCellValue(row.getCell(2));
                if(StringUtils.isEmpty(jx)){
                    return AjaxResult.error("第"+(i+1)+"行井型不能为空");
                }
                info.setJx(jx);

                String jkhzb=new DataFormatter().formatCellValue(row.getCell(3));
                if(StringUtils.isEmpty(jkhzb)){
                    return AjaxResult.error("第"+(i+1)+"行井口横坐标不能为空");
                }
                info.setJkhzb(Double.parseDouble(jkhzb));

                String jkzzb=new DataFormatter().formatCellValue(row.getCell(4));
                if(StringUtils.isEmpty(jkzzb)){
                    return AjaxResult.error("第"+(i+1)+"行井口纵坐标不能为空");
                }
                info.setJkzzb(Double.parseDouble(jkzzb));

                String gzwz=new DataFormatter().formatCellValue(row.getCell(5));
                info.setGzwz(gzwz);
                String wzcw=new DataFormatter().formatCellValue(row.getCell(6));
                info.setWzcw(wzcw);
                String ztmd=new DataFormatter().formatCellValue(row.getCell(7));
                info.setZtmd(ztmd);
                String wzyz=new DataFormatter().formatCellValue(row.getCell(8));
                info.setWzyz(wzyz);
                String wjff=new DataFormatter().formatCellValue(row.getCell(9));
                info.setWjfa(wjff);

                sjDjjcService.insertSjDjjc(info);
            }

        } catch (IOException e) {
            e.getMessage();
            e.printStackTrace();
            throw new Exception("导入Excel失败，请联系网站管理员！");

        } finally {
            workbook.close();
        }

        return AjaxResult.success("导入成功");
    }



}
