package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjLjtjztMapper;
import com.zjsgfa.project.zjsgfa.domain.SjLjtjzt;
import com.zjsgfa.project.zjsgfa.service.ISjLjtjztService;

/**
 * 设计-邻井推荐钻头Service业务层处理
 * 
 * @author
 * @date 2025-08-18
 */
@Service
public class SjLjtjztServiceImpl implements ISjLjtjztService 
{
    @Autowired
    private SjLjtjztMapper sjLjtjztMapper;

    /**
     * 查询设计-邻井推荐钻头
     * 
     * @param id 设计-邻井推荐钻头主键
     * @return 设计-邻井推荐钻头
     */
    @Override
    public SjLjtjzt selectSjLjtjztById(Long id)
    {
        return sjLjtjztMapper.selectSjLjtjztById(id);
    }

    /**
     * 查询设计-邻井推荐钻头列表
     * 
     * @param sjLjtjzt 设计-邻井推荐钻头
     * @return 设计-邻井推荐钻头
     */
    @Override
    public List<SjLjtjzt> selectSjLjtjztList(SjLjtjzt sjLjtjzt)
    {
        return sjLjtjztMapper.selectSjLjtjztList(sjLjtjzt);
    }

    /**
     * 新增设计-邻井推荐钻头
     * 
     * @param sjLjtjzt 设计-邻井推荐钻头
     * @return 结果
     */
    @Override
    public int insertSjLjtjzt(SjLjtjzt sjLjtjzt)
    {
        return sjLjtjztMapper.insertSjLjtjzt(sjLjtjzt);
    }

    /**
     * 修改设计-邻井推荐钻头
     * 
     * @param sjLjtjzt 设计-邻井推荐钻头
     * @return 结果
     */
    @Override
    public int updateSjLjtjzt(SjLjtjzt sjLjtjzt)
    {
        return sjLjtjztMapper.updateSjLjtjzt(sjLjtjzt);
    }

    /**
     * 批量删除设计-邻井推荐钻头
     * 
     * @param ids 需要删除的设计-邻井推荐钻头主键
     * @return 结果
     */
    @Override
    public int deleteSjLjtjztByIds(Long[] ids)
    {
        return sjLjtjztMapper.deleteSjLjtjztByIds(ids);
    }

    /**
     * 删除设计-邻井推荐钻头信息
     * 
     * @param id 设计-邻井推荐钻头主键
     * @return 结果
     */
    @Override
    public int deleteSjLjtjztById(Long id)
    {
        return sjLjtjztMapper.deleteSjLjtjztById(id);
    }
}
