package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.CommonFileMapper;
import com.zjsgfa.project.zjsgfa.domain.CommonFile;
import com.zjsgfa.project.zjsgfa.service.ICommonFileService;

/**
 * 文件Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-10-27
 */
@Service
public class CommonFileServiceImpl implements ICommonFileService 
{
    @Autowired
    private CommonFileMapper commonFileMapper;

    /**
     * 查询文件
     * 
     * @param id 文件主键
     * @return 文件
     */
    @Override
    public CommonFile selectCommonFileById(Long id)
    {
        return commonFileMapper.selectCommonFileById(id);
    }

    /**
     * 查询文件列表
     * 
     * @param commonFile 文件
     * @return 文件
     */
    @Override
    public List<CommonFile> selectCommonFileList(CommonFile commonFile)
    {
        return commonFileMapper.selectCommonFileList(commonFile);
    }

    /**
     * 新增文件
     * 
     * @param commonFile 文件
     * @return 结果
     */
    @Override
    public int insertCommonFile(CommonFile commonFile)
    {
        return commonFileMapper.insertCommonFile(commonFile);
    }

    /**
     * 修改文件
     * 
     * @param commonFile 文件
     * @return 结果
     */
    @Override
    public int updateCommonFile(CommonFile commonFile)
    {
        commonFile.setUpdateTime(DateUtils.getNowDate());
        return commonFileMapper.updateCommonFile(commonFile);
    }

    /**
     * 批量删除文件
     * 
     * @param ids 需要删除的文件主键
     * @return 结果
     */
    @Override
    public int deleteCommonFileByIds(Long[] ids)
    {
        return commonFileMapper.deleteCommonFileByIds(ids);
    }

    /**
     * 删除文件信息
     * 
     * @param id 文件主键
     * @return 结果
     */
    @Override
    public int deleteCommonFileById(Long id)
    {
        return commonFileMapper.deleteCommonFileById(id);
    }
}
