package com.zjsgfa.project.zjsgfa.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计-钻头选型对象 sj_ztxx
 * 
 * @author
 * @date 2025-08-18
 */
public class SjZtxx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 类别（邻井推荐/自定义） */
    @Excel(name = "类别", readConverterExp = "邻=井推荐/自定义")
    private String lb;

    /** 钻头型号 */
    @Excel(name = "钻头型号")
    private String ztxh;

    /** 开次 */
    @Excel(name = "开次")
    private String kc;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setLb(String lb) 
    {
        this.lb = lb;
    }

    public String getLb() 
    {
        return lb;
    }

    public void setZtxh(String ztxh) 
    {
        this.ztxh = ztxh;
    }

    public String getZtxh() 
    {
        return ztxh;
    }

    public void setKc(String kc) 
    {
        this.kc = kc;
    }

    public String getKc() 
    {
        return kc;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("lb", getLb())
            .append("ztxh", getZtxh())
            .append("kc", getKc())
            .toString();
    }
}
