package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjJygjInfoMapper;
import com.zjsgfa.project.zjsgfa.domain.SjJygjInfo;
import com.zjsgfa.project.zjsgfa.service.ISjJygjInfoService;

/**
 * 设计信息-井眼轨迹信息Service业务层处理
 * 
 * @author
 * @date 2025-06-26
 */
@Service
public class SjJygjInfoServiceImpl implements ISjJygjInfoService 
{
    @Autowired
    private SjJygjInfoMapper sjJygjInfoMapper;

    /**
     * 查询设计信息-井眼轨迹信息
     * 
     * @param id 设计信息-井眼轨迹信息主键
     * @return 设计信息-井眼轨迹信息
     */
    @Override
    public SjJygjInfo selectSjJygjInfoById(Long id)
    {
        return sjJygjInfoMapper.selectSjJygjInfoById(id);
    }

    /**
     * 查询设计信息-井眼轨迹信息列表
     * 
     * @param sjJygjInfo 设计信息-井眼轨迹信息
     * @return 设计信息-井眼轨迹信息
     */
    @Override
    public List<SjJygjInfo> selectSjJygjInfoList(SjJygjInfo sjJygjInfo)
    {
        return sjJygjInfoMapper.selectSjJygjInfoList(sjJygjInfo);
    }

    /**
     * 新增设计信息-井眼轨迹信息
     * 
     * @param sjJygjInfo 设计信息-井眼轨迹信息
     * @return 结果
     */
    @Override
    public int insertSjJygjInfo(SjJygjInfo sjJygjInfo)
    {
        return sjJygjInfoMapper.insertSjJygjInfo(sjJygjInfo);
    }

    /**
     * 修改设计信息-井眼轨迹信息
     * 
     * @param sjJygjInfo 设计信息-井眼轨迹信息
     * @return 结果
     */
    @Override
    public int updateSjJygjInfo(SjJygjInfo sjJygjInfo)
    {
        sjJygjInfo.setUpdateTime(DateUtils.getNowDate());
        return sjJygjInfoMapper.updateSjJygjInfo(sjJygjInfo);
    }

    /**
     * 批量删除设计信息-井眼轨迹信息
     * 
     * @param ids 需要删除的设计信息-井眼轨迹信息主键
     * @return 结果
     */
    @Override
    public int deleteSjJygjInfoByIds(Long[] ids)
    {
        return sjJygjInfoMapper.deleteSjJygjInfoByIds(ids);
    }

    /**
     * 删除设计信息-井眼轨迹信息信息
     * 
     * @param id 设计信息-井眼轨迹信息主键
     * @return 结果
     */
    @Override
    public int deleteSjJygjInfoById(Long id)
    {
        return sjJygjInfoMapper.deleteSjJygjInfoById(id);
    }
}
