package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 地质分层对象 sj_dzfc
 * 
 * @author
 * @date 2025-07-07
 */
@Data
public class SjDzfc extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 界 */
    @Excel(name = "界")
    private String dcJ;

    /** 系 */
    @Excel(name = "系")
    private String dcX;

    /** 统 */
    @Excel(name = "统")
    private String dcT;

    /** 组 */
    @Excel(name = "组")
    private String dcZ;

    /** 段 */
    @Excel(name = "段")
    private String dcD;

    /** 设计井号 */
    @Excel(name = "设计井号")
    private String sjjh;

    /** 底垂深 */
    @Excel(name = "底垂深")
    private Double sjdcs;

    /** 接触关系 */
    @Excel(name = "接触关系")
    private String sjjcgx;

    /** 厚度 */
    @Excel(name = "厚度")
    private Double sjhd;

    /** 断点深度 */
    @Excel(name = "断点深度")
    private String sjddsd;

    /** 依据井号1 */
    @Excel(name = "依据井号1")
    private String yjjh1;

    /** 依据底深1 */
    @Excel(name = "依据底深1")
    private Double yjdcs1;

    /** 接触关系1 */
    @Excel(name = "接触关系1")
    private String yjjcgx1;

    /** 含油井段1 */
    @Excel(name = "含油井段1")
    private String yjhyjd1;

    /** 断点深度1 */
    @Excel(name = "断点深度1")
    private String yjddsd1;

    //设计井岩性提示
    private String sjyxts;

    /** 依据井号2 */
    @Excel(name = "依据井号2")
    private String yjjh2;

    /** 依据底深2 */
    @Excel(name = "依据底深2")
    private Double yjdcs2;

    /** 接触关系2 */
    @Excel(name = "接触关系2")
    private String yjjcgx2;

    /** 含油井段2 */
    @Excel(name = "含油井段2")
    private String yjhyjd2;

    /** 断点深度2 */
    @Excel(name = "断点深度2")
    private String yjddsd2;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /**
     * 依据井岩性提示1
     */
    private String yjyxts1;
    /**
     * 依据井岩性提示2
     */
    private String yjyxts2;

    private String[] jhs;


    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

}
