package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjSzfxjg;
import com.zjsgfa.project.zjsgfa.service.ISjSzfxjgService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-实钻分析结果Controller
 * 
 * @author
 * @date 2025-07-22
 */
@RestController
@RequestMapping("/system/sjSzfxjg")
public class SjSzfxjgController extends BaseController
{
    @Autowired
    private ISjSzfxjgService sjSzfxjgService;

    /**
     * 查询设计-实钻分析结果列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSzfxjg:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjSzfxjg sjSzfxjg)
    {
//        startPage();
        List<SjSzfxjg> list = sjSzfxjgService.selectSjSzfxjgList(sjSzfxjg);
        return getDataTable(list);
    }

    /**
     * 导出设计-实钻分析结果列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSzfxjg:export')")
    @Log(title = "设计-实钻分析结果", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjSzfxjg sjSzfxjg)
    {
        List<SjSzfxjg> list = sjSzfxjgService.selectSjSzfxjgList(sjSzfxjg);
        ExcelUtil<SjSzfxjg> util = new ExcelUtil<SjSzfxjg>(SjSzfxjg.class);
        util.exportExcel(response, list, "设计-实钻分析结果数据");
    }

    /**
     * 获取设计-实钻分析结果详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSzfxjg:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjSzfxjgService.selectSjSzfxjgById(id));
    }

    /**
     * 新增设计-实钻分析结果
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSzfxjg:add')")
    @Log(title = "设计-实钻分析结果", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjSzfxjg sjSzfxjg)
    {
        return toAjax(sjSzfxjgService.insertSjSzfxjg(sjSzfxjg));
    }

    /**
     * 修改设计-实钻分析结果
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSzfxjg:edit')")
    @Log(title = "设计-实钻分析结果", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjSzfxjg sjSzfxjg)
    {
        return toAjax(sjSzfxjgService.updateSjSzfxjg(sjSzfxjg));
    }

    /**
     * 删除设计-实钻分析结果
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSzfxjg:remove')")
    @Log(title = "设计-实钻分析结果", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjSzfxjgService.deleteSjSzfxjgByIds(ids));
    }
}
