package com.zjsgfa.project.zjsgfa.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson2.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjJygjGdsjgdcs;
import com.zjsgfa.project.zjsgfa.service.ISjJygjGdsjgdcsService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-井眼轨迹_轨道设计各点参数Controller
 * 
 * @author
 * @date 2025-06-26
 */
@RestController
@RequestMapping("/system/sjJygjGdsjgdcs")
public class SjJygjGdsjgdcsController extends BaseController
{
    @Autowired
    private ISjJygjGdsjgdcsService sjJygjGdsjgdcsService;

    /**
     * 查询设计信息-井眼轨迹_轨道设计各点参数列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdsjgdcs:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjJygjGdsjgdcs sjJygjGdsjgdcs)
    {
//        startPage();
        List<SjJygjGdsjgdcs> list = sjJygjGdsjgdcsService.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);
        return getDataTable(list);
    }

    @GetMapping("/getList")
    public AjaxResult getList(SjJygjGdsjgdcs sjJygjGdsjgdcs)
    {
//        startPage();
        List<SjJygjGdsjgdcs> list = sjJygjGdsjgdcsService.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);
        Map<String, Object> map = new HashMap<>();
        map.put("jh", "井号");
        map.put("js", "井深");
        map.put("jx", "井斜");
        map.put("fw", "方位");
        map.put("bhfw", "闭合方位");
        map.put("cs", "垂深");
        map.put("bhj", "闭合距");
        map.put("nbwy", "南北位移");
        map.put("dxwy", "东西位移");
        map.put("zxl", "造斜率");
        map.put("fwbhl", "方位变化率");
        map.put("qjbhl", "全角变化率");
        map.put("gjm", "工具面");
        map.put("spy", "视平移");
        return AjaxResult.success(list,map);
    }

    /**
     * 导出设计信息-井眼轨迹_轨道设计各点参数列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdsjgdcs:export')")
    @Log(title = "设计信息-井眼轨迹_轨道设计各点参数", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjJygjGdsjgdcs sjJygjGdsjgdcs)
    {
        List<SjJygjGdsjgdcs> list = sjJygjGdsjgdcsService.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);
        ExcelUtil<SjJygjGdsjgdcs> util = new ExcelUtil<SjJygjGdsjgdcs>(SjJygjGdsjgdcs.class);
        util.exportExcel(response, list, "设计信息-井眼轨迹_轨道设计各点参数数据");
    }

    /**
     * 获取设计信息-井眼轨迹_轨道设计各点参数详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdsjgdcs:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjJygjGdsjgdcsService.selectSjJygjGdsjgdcsById(id));
    }

    /**
     * 新增设计信息-井眼轨迹_轨道设计各点参数
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdsjgdcs:add')")
    @Log(title = "设计信息-井眼轨迹_轨道设计各点参数", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjJygjGdsjgdcs sjJygjGdsjgdcs)
    {
        return toAjax(sjJygjGdsjgdcsService.insertSjJygjGdsjgdcs(sjJygjGdsjgdcs));
    }

    /**
     * 修改设计信息-井眼轨迹_轨道设计各点参数
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdsjgdcs:edit')")
    @Log(title = "设计信息-井眼轨迹_轨道设计各点参数", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjJygjGdsjgdcs sjJygjGdsjgdcs)
    {
        return toAjax(sjJygjGdsjgdcsService.updateSjJygjGdsjgdcs(sjJygjGdsjgdcs));
    }

    /**
     * 删除设计信息-井眼轨迹_轨道设计各点参数
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdsjgdcs:remove')")
    @Log(title = "设计信息-井眼轨迹_轨道设计各点参数", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjJygjGdsjgdcsService.deleteSjJygjGdsjgdcsByIds(ids));
    }



    /**
     * 查询井眼轨迹二维：水平投影、垂直投影图
     */
    @GetMapping("/jygjEw")
    public String jygjEw(SjJygjGdsjgdcs sjJygjGdsjgdcs)
    {
        Map jsjgt = sjJygjGdsjgdcsService.jygjEw(sjJygjGdsjgdcs);
        JSONObject jsonObject = new JSONObject(jsjgt);
        String jsonString = jsonObject.toJSONString();
        return jsonString;
    }

    /**
     * 查询井眼轨迹三维图
     */
    @GetMapping("/jygjSw")
    public String jygjSw(SjJygjGdsjgdcs sjJygjGdsjgdcs)
    {

        Map jsjgt = sjJygjGdsjgdcsService.jygjSw(sjJygjGdsjgdcs);
        JSONObject jsonObject = new JSONObject(jsjgt);
        String jsonString = jsonObject.toJSONString();
        return jsonString;
    }

}
