package com.ruoyi.project.zt.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zt.mapper.LjZjzhfxMapper;
import com.ruoyi.project.zt.domain.LjZjzhfx;
import com.ruoyi.project.zt.service.ILjZjzhfxService;

/**
 * 邻井-钻具组合分析Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-02
 */
@Service
public class LjZjzhfxServiceImpl implements ILjZjzhfxService 
{
    @Autowired
    private LjZjzhfxMapper ljZjzhfxMapper;

    /**
     * 查询邻井-钻具组合分析
     * 
     * @param id 邻井-钻具组合分析主键
     * @return 邻井-钻具组合分析
     */
    @Override
    public LjZjzhfx selectLjZjzhfxById(Long id)
    {
        return ljZjzhfxMapper.selectLjZjzhfxById(id);
    }

    /**
     * 查询邻井-钻具组合分析列表
     * 
     * @param ljZjzhfx 邻井-钻具组合分析
     * @return 邻井-钻具组合分析
     */
    @Override
    public List<LjZjzhfx> selectLjZjzhfxList(LjZjzhfx ljZjzhfx)
    {
        return ljZjzhfxMapper.selectLjZjzhfxList(ljZjzhfx);
    }

    /**
     * 新增邻井-钻具组合分析
     * 
     * @param ljZjzhfx 邻井-钻具组合分析
     * @return 结果
     */
    @Override
    public int insertLjZjzhfx(LjZjzhfx ljZjzhfx)
    {
        return ljZjzhfxMapper.insertLjZjzhfx(ljZjzhfx);
    }

    /**
     * 修改邻井-钻具组合分析
     * 
     * @param ljZjzhfx 邻井-钻具组合分析
     * @return 结果
     */
    @Override
    public int updateLjZjzhfx(LjZjzhfx ljZjzhfx)
    {
        ljZjzhfx.setUpdateTime(DateUtils.getNowDate());
        return ljZjzhfxMapper.updateLjZjzhfx(ljZjzhfx);
    }

    /**
     * 批量删除邻井-钻具组合分析
     * 
     * @param ids 需要删除的邻井-钻具组合分析主键
     * @return 结果
     */
    @Override
    public int deleteLjZjzhfxByIds(Long[] ids)
    {
        return ljZjzhfxMapper.deleteLjZjzhfxByIds(ids);
    }

    /**
     * 删除邻井-钻具组合分析信息
     * 
     * @param id 邻井-钻具组合分析主键
     * @return 结果
     */
    @Override
    public int deleteLjZjzhfxById(Long id)
    {
        return ljZjzhfxMapper.deleteLjZjzhfxById(id);
    }
}
