package com.ruoyi.project.zt.mapper;

import com.ruoyi.framework.aspectj.lang.annotation.DataSource;
import com.ruoyi.framework.aspectj.lang.enums.DataSourceType;
import com.ruoyi.project.zt.domain.Jsba;

import java.util.List;

/**
 * 地质简介基本数据Mapper接口
 * 
 * @author ruoyi
 * @date 2025-07-10
 */
@DataSource(value = DataSourceType.SLAVE)
public interface JsbaMapper 
{
    /**
     * 查询地质简介基本数据
     * 
     * @param jh 地质简介基本数据主键
     * @return 地质简介基本数据
     */
    public Jsba selectJsbaByJh(String jh);

    /**
     * 查询地质简介基本数据列表
     * 
     * @param jsba 地质简介基本数据
     * @return 地质简介基本数据集合
     */
    public List<Jsba> selectJsbaList(Jsba jsba);

    /**
     * 新增地质简介基本数据
     * 
     * @param jsba 地质简介基本数据
     * @return 结果
     */
    public int insertJsba(Jsba jsba);

    /**
     * 修改地质简介基本数据
     * 
     * @param jsba 地质简介基本数据
     * @return 结果
     */
    public int updateJsba(Jsba jsba);

    /**
     * 删除地质简介基本数据
     * 
     * @param jh 地质简介基本数据主键
     * @return 结果
     */
    public int deleteJsbaByJh(String jh);

    /**
     * 批量删除地质简介基本数据
     * 
     * @param jhs 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteJsbaByJhs(String[] jhs);
}
