package com.ruoyi.project.zt.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 邻井-钻具组合分析对象 lj_zjzhfx
 * 
 * @author ruoyi
 * @date 2025-07-02
 */
public class LjZjzhfx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 开次 */
    @Excel(name = "开次")
    private String kc;

    /** 钻具组合模型 */
    @Excel(name = "钻具组合模型")
    private String zjzhmx;

    /** 特殊钻具 */
    @Excel(name = "特殊钻具")
    private String tsgj;

    /** 钻具组合 */
    @Excel(name = "钻具组合")
    private String zjzh;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setKc(String kc) 
    {
        this.kc = kc;
    }

    public String getKc() 
    {
        return kc;
    }

    public void setZjzhmx(String zjzhmx) 
    {
        this.zjzhmx = zjzhmx;
    }

    public String getZjzhmx() 
    {
        return zjzhmx;
    }

    public void setTsgj(String tsgj) 
    {
        this.tsgj = tsgj;
    }

    public String getTsgj() 
    {
        return tsgj;
    }

    public void setZjzh(String zjzh) 
    {
        this.zjzh = zjzh;
    }

    public String getZjzh() 
    {
        return zjzh;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("kc", getKc())
            .append("zjzhmx", getZjzhmx())
            .append("tsgj", getTsgj())
            .append("zjzh", getZjzh())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
