package com.ruoyi.project.zt.controller;

import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.project.zt.domain.Jsaa;
import com.ruoyi.project.zt.service.IJsaaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 基础数据Controller
 * 
 * @author ruoyi
 * @date 2025-07-10
 */
@RestController
@RequestMapping("/system/jsaa")
public class JsaaController extends BaseController
{
    @Autowired
    private IJsaaService jsaaService;

    /**
     * 查询基础数据列表
     */
    @PreAuthorize("@ss.hasPermi('system:jsaa:list')")
    @GetMapping("/list")
    public TableDataInfo list(Jsaa jsaa)
    {
        startPage();
        List<Jsaa> list = jsaaService.selectJsaaList(jsaa);
        return getDataTable(list);
    }



    /**
     * 导出基础数据列表
     */
    @PreAuthorize("@ss.hasPermi('system:jsaa:export')")
    @Log(title = "基础数据", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Jsaa jsaa)
    {
        List<Jsaa> list = jsaaService.selectJsaaList(jsaa);
        ExcelUtil<Jsaa> util = new ExcelUtil<Jsaa>(Jsaa.class);
        util.exportExcel(response, list, "基础数据");
    }

    /**
     * 获取基础数据详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:jsaa:query')")
    @GetMapping(value = "/{jh}")
    public AjaxResult getInfo(@PathVariable("jh") String jh)
    {
        return success(jsaaService.selectJsaaByJh(jh));
    }

    /**
     * 新增基础数据
     */
    @PreAuthorize("@ss.hasPermi('system:jsaa:add')")
    @Log(title = "基础数据", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Jsaa jsaa)
    {
        return toAjax(jsaaService.insertJsaa(jsaa));
    }

    /**
     * 修改基础数据
     */
    @PreAuthorize("@ss.hasPermi('system:jsaa:edit')")
    @Log(title = "基础数据", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Jsaa jsaa)
    {
        return toAjax(jsaaService.updateJsaa(jsaa));
    }

    /**
     * 删除基础数据
     */
    @PreAuthorize("@ss.hasPermi('system:jsaa:remove')")
    @Log(title = "基础数据", businessType = BusinessType.DELETE)
	@DeleteMapping("/{jhs}")
    public AjaxResult remove(@PathVariable String[] jhs)
    {
        return toAjax(jsaaService.deleteJsaaByJhs(jhs));
    }






}
