package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjZtxxMapper;
import com.ruoyi.project.zjsgfa.domain.SjZtxx;
import com.ruoyi.project.zjsgfa.service.ISjZtxxService;

/**
 * 设计-钻头选型Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-08-18
 */
@Service
public class SjZtxxServiceImpl implements ISjZtxxService 
{
    @Autowired
    private SjZtxxMapper sjZtxxMapper;

    /**
     * 查询设计-钻头选型
     * 
     * @param id 设计-钻头选型主键
     * @return 设计-钻头选型
     */
    @Override
    public SjZtxx selectSjZtxxById(Long id)
    {
        return sjZtxxMapper.selectSjZtxxById(id);
    }

    /**
     * 查询设计-钻头选型列表
     * 
     * @param sjZtxx 设计-钻头选型
     * @return 设计-钻头选型
     */
    @Override
    public List<SjZtxx> selectSjZtxxList(SjZtxx sjZtxx)
    {
        return sjZtxxMapper.selectSjZtxxList(sjZtxx);
    }

    /**
     * 新增设计-钻头选型
     * 
     * @param sjZtxx 设计-钻头选型
     * @return 结果
     */
    @Override
    public int insertSjZtxx(SjZtxx sjZtxx)
    {
        return sjZtxxMapper.insertSjZtxx(sjZtxx);
    }

    /**
     * 修改设计-钻头选型
     * 
     * @param sjZtxx 设计-钻头选型
     * @return 结果
     */
    @Override
    public int updateSjZtxx(SjZtxx sjZtxx)
    {
        return sjZtxxMapper.updateSjZtxx(sjZtxx);
    }

    /**
     * 批量删除设计-钻头选型
     * 
     * @param ids 需要删除的设计-钻头选型主键
     * @return 结果
     */
    @Override
    public int deleteSjZtxxByIds(Long[] ids)
    {
        return sjZtxxMapper.deleteSjZtxxByIds(ids);
    }

    /**
     * 删除设计-钻头选型信息
     * 
     * @param id 设计-钻头选型主键
     * @return 结果
     */
    @Override
    public int deleteSjZtxxById(Long id)
    {
        return sjZtxxMapper.deleteSjZtxxById(id);
    }
}
