package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjZjcsxxMapper;
import com.ruoyi.project.zjsgfa.domain.SjZjcsxx;
import com.ruoyi.project.zjsgfa.service.ISjZjcsxxService;

/**
 * 设计-钻具参数信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-08-18
 */
@Service
public class SjZjcsxxServiceImpl implements ISjZjcsxxService 
{
    @Autowired
    private SjZjcsxxMapper sjZjcsxxMapper;

    /**
     * 查询设计-钻具参数信息
     * 
     * @param id 设计-钻具参数信息主键
     * @return 设计-钻具参数信息
     */
    @Override
    public SjZjcsxx selectSjZjcsxxById(Long id)
    {
        return sjZjcsxxMapper.selectSjZjcsxxById(id);
    }

    /**
     * 查询设计-钻具参数信息列表
     * 
     * @param sjZjcsxx 设计-钻具参数信息
     * @return 设计-钻具参数信息
     */
    @Override
    public List<SjZjcsxx> selectSjZjcsxxList(SjZjcsxx sjZjcsxx)
    {
        return sjZjcsxxMapper.selectSjZjcsxxList(sjZjcsxx);
    }

    /**
     * 新增设计-钻具参数信息
     * 
     * @param sjZjcsxx 设计-钻具参数信息
     * @return 结果
     */
    @Override
    public int insertSjZjcsxx(SjZjcsxx sjZjcsxx)
    {
        return sjZjcsxxMapper.insertSjZjcsxx(sjZjcsxx);
    }

    /**
     * 修改设计-钻具参数信息
     * 
     * @param sjZjcsxx 设计-钻具参数信息
     * @return 结果
     */
    @Override
    public int updateSjZjcsxx(SjZjcsxx sjZjcsxx)
    {
        return sjZjcsxxMapper.updateSjZjcsxx(sjZjcsxx);
    }

    /**
     * 批量删除设计-钻具参数信息
     * 
     * @param ids 需要删除的设计-钻具参数信息主键
     * @return 结果
     */
    @Override
    public int deleteSjZjcsxxByIds(Long[] ids)
    {
        return sjZjcsxxMapper.deleteSjZjcsxxByIds(ids);
    }

    /**
     * 删除设计-钻具参数信息信息
     * 
     * @param id 设计-钻具参数信息主键
     * @return 结果
     */
    @Override
    public int deleteSjZjcsxxById(Long id)
    {
        return sjZjcsxxMapper.deleteSjZjcsxxById(id);
    }
}
